# Context‑Level vs. Wilson‑Loop Fluctuation Correlation Validation

This repository contains a reproducible pipeline for validating the predicted correlation between local context depth (flip counts) and local Wilson‑loop fluctuations in the Absolute Relativity theory.  It loads per‑link flip counts and gauge‑field ensembles, computes local Wilson‑loop variances across plaquette loops of various sizes for different gauge groups, and quantifies the correlation between flip counts and fluctuations.  Bootstrapping is used to estimate confidence intervals for the correlation coefficients.  A report summarising the theory, methods, results and conclusions can be generated.

## Repository structure

```
ar-context-correlation-validation/
├── README.md               # this file
├── config.yaml             # pipeline configuration
├── data/
│   ├── flip_counts.npy       # 32-entry flip counts (replace with real data)
│   └── gauge_configs/        # gauge-field ensembles; sub-files per gauge group
├── scripts/
│   ├── run_correlation.py    # main analysis script
│   └── generate_report.py    # report generation script
├── results/
│   ├── correlation_full.csv  # correlation table output
│   └── figures/              # generated figures
├── requirements.txt          # Python dependencies
```

### Data requirements

- **Flip counts**: place a NumPy array of length 32 in `data/flip_counts.npy`. Each entry corresponds to the number of tick‑flip operations on a link in a 4×4 periodic lattice (2 directions × 16 sites = 32 links). If you set a `noise_level` in the configuration, a small amount of Gaussian noise will be added to these counts before analysis.

- **Gauge-field configurations**: under `data/gauge_configs/`, provide `ensemble_size` files per gauge group specified in `config.yaml`. Files must be named `<group>_cfg_<index>.npy`, where `<group>` is the gauge group (e.g. `U1`, `SU2`, `SU3`) and `<index>` is a zero‑padded integer from `0` to `ensemble_size-1`. Each `.npy` file should contain a 3‑D or 4‑D array representing the link matrices on a 4×4 lattice:

  * For **U1**, each entry is a complex phase (dimension 1×1). The array shape should be `(L, L, 2)` or `(L, L, 2, 1, 1)`.
  * For **SU2**, each entry is a 2×2 complex unitary matrix. The shape should be `(L, L, 2, 2, 2)`.
  * For **SU3**, each entry is a 3×3 complex unitary matrix. The shape should be `(L, L, 2, 3, 3)`.

  Here, `L = sqrt(len(flip_counts)/2) = 4`. The second‑to‑last dimension indexes the two spatial directions (0 for the x‑direction and 1 for the y‑direction). Matrices should respect periodic boundary conditions.

The scripts operate generically on these shapes; if a file cannot be found or is malformed, a random unitary or identity matrix will be generated as a placeholder.

## Installation and usage

Install the dependencies and run the analysis and report generation scripts as follows:

```bash
git clone context-correlation-validation
cd context-correlation-validation
pip install -r requirements.txt
python scripts/run_correlation.py
python scripts/generate_report.py
```

The `results/correlation_full.csv` file will contain the computed correlation coefficients, p‑values and confidence intervals for each gauge group and loop size. The bar charts and summary figures will be saved under `results/figures/`. The final report will be written to `REPORT_context_correlation_final.md` at the repository root.